<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?id=34&alias=linee-guida-per-l%2527uso-del-logo-geecom
    */

    include "include/includeBase.php";    
    include "include/controlloLogin.php";
    
    if(isset($_GET["id"])) {
        $idMenu    = filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT);
        $menu      = $geecomDb->leggiSingolaRiga("geecD_menu",$idMenu);
        $parametriRicerca = array("idMenu"=>$menu["id"]); // escludere menu a tendina e voci sottomenu
        $parametri = array("tabella"=>"geecD_vociMenu","elementiPerPagina"=>100,"parametriRicerca"=>$parametriRicerca,"ajax"=>false);
        $impostazioniRicerca["ordinamentoBase"] = "ORDER BY posizione ASC";
        $ricerca   = new Ricerca($geecomDb, $parametri, $impostazioniRicerca, "creaMenu.php");
        $ricerca->setParametriDaEscludere(array("tipo"=>"voce sottomenu"));
    }
    
    $tipiMenu = array("link","link a un contenuto","menu a tendina","voce sottomenu");
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
        <title>Geecom Admin - Creazione menu</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "include/barraSuperiore.php";

                include "include/header.php";

                include "include/barraMenu.php";
            ?>
        </header>

        <main role="main" class="bg-light" id="main">
		<div class="container-fluid">
                    <div class="row">
                        <!-- Colonna principale -->
                        <div class="col py-4">
                            <div class="card mb-4 box-shadow-lite">
                                <div class="card-header py-2">
                                    <form action="../controller/controllerMenu.php" method="POST">
                                        <div class="row">
                                            <input type="text" class="d-none" name="operazione" value="<?php echo(isset($menu) ? "modifica" : "crea")?>">
                                            <input type="text" class="d-none" name="id" value="<?php echo(isset($menu) ? $menu["id"] : "0")?>">
                                            <div class="col-3 col-lg-2">
                                                <h6 class="mt-2">Nome menu:</h6>
                                            </div>
                                            <div class="col-9 col-lg-4">
                                                <input type="text" class="form-control" id="nomeMenu" name="nome" aria-describedby="nome Menu" value="<?php echo(isset($menu) ? $menu["nome"] : "")?>" placeholder="es.: menu principale">
                                            </div>
                                            <div class="col-4 col-lg-2">
                                                <div class="d-none">
                                                    <input type="checkbox" name="formRicerca" class="js-switch" value="si" <?php echo((isset($menu) && $mhenu["formRicerca"]=="si") ? "checked" : "")?> />
                                                    <label class="mb-0">Mostra ricerca</label>
                                                </div>
                                            </div>
                                            <div class="col-8 col-lg-4 text-right">
                                                <a class="btn btn-outline-primary mt-2 mt-md-0" href="gestioneMenu.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                                <button class="btn btn-primary mt-2 mt-md-0"><i class="fas fa-check"></i> Salva</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <?php 
                                    if(isset($menu)) {
                                ?>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-sm-4 col-xl-3">
                                            <form>
                                                <div class="mb-4 add-box">
                                                    <h6 class="mb-3"> Aggiungi una voce di menu </h6>
                                                    <div class="options-box">
                                                        
                                                        <div class="form-group">
                                                            <select class="form-control" id="tipoVoceMenu" onchange="mostraCampi(this.value)">
                                                                <?php 
                                                                    foreach($tipiMenu as $tipo) {
                                                                        echo"<option value=\"$tipo\">$tipo</option>";
                                                                    }
                                                                ?>
                                                            </select>
                                                        </div>
                                                        
                                                        <div id="divIdContenuto" class="d-none">
                                                            <label for="nome-voce-menu-3">Contenuto</label>
                                                            <select class="selectpicker" id="idContenuto" name="idContenuto"  data-width="100%" data-live-search="true">
                                                                <option value="0">Seleziona</option>
                                                                <?php
                                                                    $queryTag = "SELECT * FROM geecD_contenuti";
                                                                    $result   = $geecomDb->eseguiQueryLettura($queryTag);
                                                                    while($contenuto = $result->fetch_assoc()) {
                                                                        echo"<option value=\"{$contenuto["id"]}\" data-subtext=\"{$contenuto["tipo"]}\">{$contenuto["titolo"]}</option>";
                                                                    }
                                                                ?>
                                                            </select>
                                                        </div>
                                                        
                                                        <div class="form-group">
                                                            <label for="nome-voce-menu-1">Nome</label>
                                                            <input type="text" class="form-control" id="nomeVoceMenu" name="nome" placeholder="Nome">
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="nome-voce-menu-2">Icona</label>
                                                            <input type="text" class="form-control" id="iconaVoceMenu" name="icona" placeholder="Icona">
                                                        </div>
                                                        <div class="form-group" id="divLinkMenu">
                                                            <label for="nome-voce-menu-3">Link</label>
                                                            <input type="text" class="form-control" name="link" value="http://" id="linkVoceMenu" placeholder="Link">
                                                        </div>
                                                        <div class="d-none" id="divVocePadre">
                                                            <label for="nome-voce-menu-3">Voce padre</label>
                                                            <select class="form-control" id="idVocePadre" name="vocePadre" >
                                                                <option value="0">Seleziona</option>
                                                                <?php
                                                                    $queryTag = "SELECT * FROM geecD_vociMenu WHERE idMenu=$idMenu AND tipo LIKE 'menu a tendina'";
                                                                    $result   = $geecomDb->eseguiQueryLettura($queryTag);
                                                                    while($voceMenu = $result->fetch_assoc()) {
                                                                        echo"<option value=\"{$voceMenu["id"]}\">{$voceMenu["nome"]}</option>";
                                                                    }
                                                                ?>
                                                            </select>
                                                        </div>
                                                        <button type="button" class="btn btn-primary float-right" value="Crea"  onclick="creaVoceMenu()"><i class="fas fa-plus mr-2"></i>Crea</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                        <div class="col-sm-8 col-xl-9 mb-4 gerarchia-menu" id="elencoVociMenu">
                                            <?php 
                                                $ris = $ricerca->eseguiRicerca(1);
                                                while($voceMenu = $ris->fetch_assoc()) {
                                                    $posizionePrecedente = ($voceMenu["posizione"]<=1) ? 1 : $voceMenu["posizione"] - 1;
                                                    $posizioneSuccesiva  = $voceMenu["posizione"] +1;
                                                    if($voceMenu["tipo"]!="menu a tendina") {
                                                        $stringaIcona = ($voceMenu["icona"]!="") ? "<i class=\"{$voceMenu["icona"]}\"></i>" : "";
                                                        echo"<div id=\"voceMenu{$voceMenu["id"]}\" class=\"card-body mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                                                                <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                                                                    <p class=\"mb-0\"><em><strong>$stringaIcona {$voceMenu["nome"]}</strong></em>  </p>
                                                                    <small><em>{$voceMenu["link"]}</em>  </small>
                                                                </div>
                                                                <div class=\"azioni d-flex align-items-center justify-content-end\">
                                                                    <form class=\"d-inline-flex mr-sm-1\">
                                                                        <div class=\"input-group input-group-sm d-flex align-items-center\">
                                                                            <small class=\"text-muted mr-2\">Pos.</small>
                                                                            <input type=\"number\" id=\"nuovaPosizioneVoceMenu{$voceMenu["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$voceMenu["posizione"]}\">
                                                                            <div class=\"input-group-append\">
                                                                                <button class=\"btn btn-primary\" type=\"button\" onclick=\"spostaVoceMenuInput({$voceMenu["id"]},0)\">Salva</button>
                                                                            </div>
                                                                        </div>
                                                                    </form>
                                                                    <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                                                        <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta su\" onclick=\"spostaVoceMenu({$voceMenu["id"]},$posizionePrecedente)\"><i class=\"fas fa-arrow-up\" ></i></button>
                                                                        <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta giu\" onclick=\"spostaVoceMenu({$voceMenu["id"]},$posizioneSuccesiva)\"><i class=\"fas fa-arrow-down\"></i></button>
                                                                        <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Configura elemento\" onclick=\"modificaVoceMenu({$voceMenu["id"]},{$voceMenu["idContenuto"]},'{$voceMenu["nome"]}','{$voceMenu["icona"]}','{$voceMenu["link"]}','{$voceMenu["tipo"]}')\"><i class=\"fas fa-cog\"></i></button>
                                                                        <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaVoceMenu({$voceMenu["id"]},'{$voceMenu["nome"]}','{$voceMenu["tipo"]}')\" ><i class=\"far fa-trash-alt\"></i></button>
                                                                    </div>
                                                               </div>
                                                            </div>";
                                                    }
                                                    else {
                                                        stampaVociSottomenu($geecomDb,$voceMenu);
                                                    }
                                                }
                                            ?>
                                        </div>

                                        <div class="col-12 text-right">
                                            <a class="btn btn-outline-primary" href="gestioneMenu.php"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                            <button class="btn btn-primary"><i class="fas fa-check"></i> Salva</button>
                                        </div>
                                    </div>
                                </div>
                                <?php 
                                    }
                                ?>
                            </div>
                        </div><!-- /Colonna principale -->
                    </div>
		</div>
        </main>
        
        <?php 
            include "include/footer.php";
            
            include "include/modal/cambiaPassword.php";
            
            include "include/modal/modalMenuComponenti.php";
            
            include "include/modal/operazioneCompletata.php";
        ?>
	  
        
	<!-- MODALS  -->
        <div class="modal fade" id="modalComponenteAggiornato" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content bg-transparent">
                    <div class="modal-body m-0 p-0">
                        <div class="alert alert-success p-3 mb-0">
                            Componente aggiornato con successo
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="modal fade" id="modalEliminaElemento" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare la voce di menu?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                            <div class="align-self-center text-center">
                                <span class="align-self-center text-primary"><em id="nomeVoceMenuDaEliminare"></em></span>
                                <div id="tipoElementoDaEliminare"></div>
                            </div>
                        </div>
                        <input type="text" class="d-none" id="voceMenuDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneVoceMenu()"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
        <?php 
            if(isset($menu)) {
        ?>
        <div class="modal fade" id="modifica-voce-menu" tabindex="-1" role="dialog" aria-labelledby="modifica-voce-menu" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLongTitle">Modifica la voce di menu</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form>
                            <input type="text" class="d-none" id="idVoceMenuDaModificare" name="id">
                            <div class="form-group">
                                <select class="form-control" id="tipoVoceMenuDaModificare" onchange="mostraCampiModalModifcaVoce(this.value)">
                                    <?php 
                                        foreach($tipiMenu as $tipo) {
                                            echo"<option value=\"$tipo\">$tipo</option>";
                                        }
                                    ?>
                                </select>
                            </div>

                            <div id="divIdContenutoDaModificare" class="d-none">
                                <label for="nome-voce-menu-3">Contenuto</label>
                                <select class="selectpicker" id="idContenutoDaModificare" name="idContenuto"  data-width="100%" data-live-search="true" >
                                    <option value="0">Seleziona</option>
                                    <?php
                                        $queryTag = "SELECT * FROM geecD_contenuti";
                                        $result   = $geecomDb->eseguiQueryLettura($queryTag);
                                        while($contenuto = $result->fetch_assoc()) {
                                            echo"<option value=\"{$contenuto["id"]}\">{$contenuto["titolo"]}</option>";
                                        }
                                    ?>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="nome-voce-menu-1">Nome</label>
                                <input type="text" class="form-control" id="nomeVoceMenuDaModificare" name="nome" placeholder="Nome">
                            </div>

                            <div class="form-group">
                                <label for="nome-voce-menu-2">Icona</label>
                                <input type="text" class="form-control" id="iconaVoceMenuDaModificare" name="icona" placeholder="Icona">
                            </div>

                            <div class="form-group" id="divLinkMenuDaModificare">
                                <label for="nome-voce-menu-3">Link</label>
                                <input type="text" class="form-control" name="link" id="linkVoceMenuDaModificare" placeholder="Link">
                            </div>

                            <div class="d-none" id="divVocePadreDaModificare">
                                <label for="nome-voce-menu-3">Voce padre</label>
                                <select class="form-control" id="idVocePadre" name="vocePadre" >
                                    <?php
                                        $queryTag = "SELECT * FROM geecD_vociMenu WHERE idMenu=$idMenu AND tipo LIKE 'menu a tendina'";
                                        $result   = $geecomDb->eseguiQueryLettura($queryTag);
                                        while($voceMenu = $result->fetch_assoc()) {
                                            echo"<option value=\"{$voceMenu["id"]}\">{$voceMenu["nome"]}</option>";
                                        }
                                    ?>
                                </select>
                            </div>
                      </form>
                    </div>
                    <div class="modal-footer">
                          <button type="button" class="btn btn-secondary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                          <button type="button" class="btn btn-primary btn-sm" onclick="eseguiModificaVoceMenu()"><i class="fas fa-check"></i> Salva</button>
                    </div>
                </div>
            </div>
        </div>    
        <?php
            }
            include "include/jsBaseAreaAmministrativa.php";
        ?>
        <!-- Dropzone -->


        <script>
            
            function modificaImpostazioniSezione() {
                $('#modifica-impostazioni-sezione').modal('show');
            }
            
            function eliminaComponentePagina(id,immagineComponente,nomeComponente,nomeElemento) {
                $('#componenteDaEliminare').val(id);
                document.getElementById("immagineComponenteDaEliminare").src = immagineComponente;
                $('#nomeComponenteDaEliminare').text(nomeComponente);
                document.getElementById("nomeVoceMenuDaEliminare").innerHTML = nomeElemento;
                $('#modalEliminaComponente').modal('show');
            }
            
            function eseguiEliminazioneComponentePagina() {
                var id = $('#componenteDaEliminare').val();
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"eliminaComponente",
                        id:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("componentePagina"+id).className = "d-none";
                            $('#modalEliminaComponente').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function cambiaIdElemento(idComponente) {
                var idElemento = $("#idElementoComponente"+idComponente).val();
                $.ajax({
                    type:"GET",
                    url:"../controller/controllerContenuti.php",
                    data:{
                        operazione:"cambiaIdElemento",
                        id:idComponente,
                        idElemento:idElemento
                    },
                    success:function(result) {
                        if(result=="ok") {
                            $('#modalComponenteAggiornato').modal('show');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            //questa funzione viene usata quando si crea una voce di menu, fa comparire i campi necessari in
            //base al tipo di menu scelto. Si attiva ogni volta che la select tipo cambia valores
            function mostraCampi(scelta) {
                document.getElementById("divLinkMenu").className = "d-none";
                document.getElementById("divVocePadre").className = "d-none";
                document.getElementById("divIdContenuto").className = "d-none";
                
                if(scelta=="menu a tendina") {
                    //nessuna azione necessaria, i div non devono essere visibili
                }
                else if(scelta=="link a un contenuto") {
                    document.getElementById("divIdContenuto").className  = "form-group";
                }
                else if(scelta=="voce sottomenu") {
                    document.getElementById("divLinkMenu").className  = "form-group";
                    document.getElementById("divVocePadre").className = "form-group";
                }
                else if(scelta=="link immagine") {
                    document.getElementById("divLinkMenu").className  = "form-group";
                }
                else { //scelta = link
                    document.getElementById("divLinkMenu").className  = "form-group";
                }
            }
            
            function mostraCampiModalModifcaVoce(scelta) {
                document.getElementById("divLinkMenuDaModificare").className = "d-none";
                document.getElementById("divVocePadreDaModificare").className = "d-none";
                document.getElementById("divIdContenutoDaModificare").className = "d-none";
                
                if(scelta=="menu a tendina") {
                    //nessuna azione necessaria, i div non devono essere visibili
                }
                else if(scelta=="link a un contenuto") {
                    document.getElementById("divIdContenutoDaModificare").className  = "form-group";
                }
                else if(scelta=="voce sottomenu") {
                    document.getElementById("divLinkMenuDaModificare").className  = "form-group";
                    document.getElementById("divVocePadreDaModificare").className = "form-group";
                }
                else if(scelta=="link immagine") {
                    document.getElementById("divLinkMenuDaModificare").className  = "form-group";
                }
                else { //scelta = link
                    document.getElementById("divLinkMenuDaModificare").className  = "form-group";
                }
            }
            
            function creaVoceMenu() {
                var tipo  = $('#tipoVoceMenu').val();
                var idContenuto = $('#idContenuto').val();
                var nome  = $('#nomeVoceMenu').val();
                var icona = $('#iconaVoceMenu').val();
                var link  = $('#linkVoceMenu').val();
                var vocePadre       = $('#idVocePadre').val();
                
                if(nome=="" && icona=="") {
                    alert("Inserisci almeno un nome o un'icona");
                }
                else {
                    
                    $.ajax({
                        type:"POST",
                        url:"../controller/controllerMenu.php",
                        data:{
                            operazione:"creaVoceMenu",
                            id:<?php echo $menu["id"] ?>,
                            idContenuto:idContenuto,
                            tipo:tipo,
                            nome:nome,
                            icona:icona,
                            link:link,
                            vocePadre:vocePadre,
                        },
                        success:function(codiceHtml) {
                            var elencoVociMenu = document.getElementById("elencoVociMenu");
                            elencoVociMenu.innerHTML = elencoVociMenu.innerHTML + codiceHtml;
                            if(tipo=="menu a tendina" || tipo=="voce sottomenu") {
                                location.reload();
                            }
                        },
                        error: function() {
                            alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                        }
                    });
                }
            }
          
            function modificaVoceMenu(id,idContenuto,nome,icona,link,tipo) {
                $('#idVoceMenuDaModificare').val(id);
                $('#tipoVoceMenuDaModificare').val(tipo);
                $('#idContenutoDaModificare').val(idContenuto);
                $('#nomeVoceMenuDaModificare').val(nome);
                $('#iconaVoceMenuDaModificare').val(icona);
                $('#linkVoceMenuDaModificare').val(link);
                $('#modifica-voce-menu').modal('show');
            }
       
            function eseguiModificaVoceMenu() {
                var id = $('#idVoceMenuDaModificare').val();
                var tipo  = $('#tipoVoceMenuDaModificare').val();
                var idContenuto = $('#idContenutoDaModificare').val();
                var nome  = $('#nomeVoceMenuDaModificare').val();
                var icona = $('#iconaVoceMenuDaModificare').val();
                var link  = $('#linkVoceMenuDaModificare').val();
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerMenu.php",
                    data:{
                        operazione:"modificaVoceMenu",
                        id:<?php echo $menu["id"] ?>,
                        idVoceMenu:id,
                        idContenuto:idContenuto,
                        tipo:tipo,
                        nome:nome,
                        icona:icona,
                        link:link,
                    },
                    success:function(esito) {
                        if(esito==="ok" && tipo==="menu a tendina") {
                            location.reload();
                        }
                        else if(esito==="ok") {
                            aggiornaElencoVociMenu();
                        }
                        else {
                            alert(result)
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
               
            function spostaVoceMenuInput(id) {
                var posizione = $('#nuovaPosizioneVoceMenu'+id).val();
                spostaVoceMenu(id,posizione);
            }
            
            function spostaVoceMenu(id,posizione) {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerMenu.php",
                    data:{
                        operazione:"spostaVoceMenu",
                        id:<?php echo $menu["id"] ?>,
                        idVoce:id,
                        posizione:posizione
                    },
                    success:function(result) {
                        if(result=="ok") {
                            aggiornaElencoVociMenu();
                        }
                        else {
                            alert(result);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function aggiornaElencoVociMenu() {
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerMenu.php",
                    data:{
                        operazione:"stampaVociMenu",
                        id:<?php echo $menu["id"] ?>
                    },
                    success:function(result) {
                        document.getElementById("elencoVociMenu").innerHTML = result;
                        $('#modifica-voce-menu').modal('hide');
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
            
            function eliminaVoceMenu(id,nomeElemento,tipoElemento) {
                $('#voceMenuDaEliminare').val(id);
                $('#nomeVoceMenuDaEliminare').text(nomeElemento);
                document.getElementById("tipoElementoDaEliminare").innerHTML = tipoElemento;
                $('#modalEliminaElemento').modal('show');
            }
            
            function eseguiEliminazioneVoceMenu() {
                var id = $('#voceMenuDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerMenu.php",
                    data:{
                        operazione:"eliminaVoceMenu",
                        id:<?php echo $menu["id"] ?>,
                        idVoceMenu:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("voceMenu"+id).className = "d-none";
                            $('#modalEliminaElemento').modal('hide');
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
  </body>
</html>

<?php
    function stampaVociSottomenu($geecomDb,$voceMenu) {
        $posizionePrecedente = ($voceMenu["posizione"]<=1) ? 1 : $voceMenu["posizione"] - 1;
        $posizioneSuccesiva  = $voceMenu["posizione"] +1;
        $stringaIcona = ($voceMenu["icona"]!="") ? "<i class=\"{$voceMenu["icona"]}\"></i>" : "";
        
        echo"<div class=\"card mb-3\" id=\"voceMenu{$voceMenu["id"]}\">
                <div class=\"card-header py-1 px-2 bg-light rounded d-sm-flex justify-content-between align-items-center text-center\">
                    <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                        <a href=\"#sottomenu{$voceMenu["id"]}\" data-toggle=\"collapse\" class=\"mb-0\"><em><strong>$stringaIcona {$voceMenu["nome"]}</strong></em>  </a>
                        <small class=\"d-block\"><em>{$voceMenu["link"]}</em>  </small>
                    </div>
                    <div class=\"azioni d-flex align-items-center justify-content-end\">
                        <form class=\"d-inline-flex mr-sm-1\">
                            <div class=\"input-group input-group-sm d-flex align-items-center\">
                                <small class=\"text-muted mr-2\">Pos.</small>
                                <input type=\"number\" id=\"nuovaPosizioneVoceMenu{$voceMenu["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$voceMenu["posizione"]}\">
                                <div class=\"input-group-append\">
                                    <button class=\"btn btn-primary\" type=\"button\" onclick=\"spostaVoceMenuInput({$voceMenu["id"]},0)\">Salva</button>
                                </div>
                            </div>
                        </form>
                        <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                            <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta su\" onclick=\"spostaVoceMenu({$voceMenu["id"]},$posizionePrecedente)\"><i class=\"fas fa-arrow-up\" ></i></button>
                            <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta giu\" onclick=\"spostaVoceMenu({$voceMenu["id"]},$posizioneSuccesiva)\"><i class=\"fas fa-arrow-down\"></i></button>
                            <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Configura elemento\" onclick=\"modificaVoceMenu({$voceMenu["id"]},{$voceMenu["idContenuto"]},'{$voceMenu["nome"]}','{$voceMenu["icona"]}','{$voceMenu["link"]}','{$voceMenu["tipo"]}',{$voceMenu["gruppoSpecifico"]})\"><i class=\"fas fa-cog\"></i></button>
                            <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaVoceMenu({$voceMenu["id"]},'{$voceMenu["nome"]}','{$voceMenu["tipo"]}')\" ><i class=\"far fa-trash-alt\"></i></button>
                        </div>
                   </div>
                </div>
                <div class=\"collapse show\" id=\"sottomenu{$voceMenu["id"]}\">"
                . "<div class=\"card-body pb-1\" >";
                    $queryVociDiMenu = "SELECT * FROM geecD_vociMenu WHERE idMenu={$voceMenu["idMenu"]} AND tipo LIKE 'voce sottomenu' AND vocePadre='{$voceMenu["id"]}' ORDER BY posizione ASC";
                    $risVociSottomenu   = $geecomDb->eseguiQueryLettura($queryVociDiMenu);
                    while($voceSottoMenu = $risVociSottomenu->fetch_assoc()) {
                        $stringaIcona = ($voceSottoMenu["icona"]!="") ? "<i class=\"{$voceSottoMenu["icona"]}\"></i>" : "";
                        echo"<div id=\"voceMenu{$voceSottoMenu["id"]}\" class=\"mb-3 py-1 px-2 bg-light border rounded d-sm-flex justify-content-between align-items-center text-center\">
                                <div class=\"mb-1 mb-sm-0 text-muted w-50 text-left\">
                                    <p class=\"mb-0\"><em><strong>$stringaIcona {$voceSottoMenu["nome"]}</strong></em>  </p>
                                    <small><em>{$voceSottoMenu["link"]}</em></small>
                                </div>
                                <div class=\"azioni d-flex align-items-center justify-content-end\">
                                    <form class=\"d-inline-flex mr-sm-1\">
                                        <div class=\"input-group input-group-sm d-flex align-items-center\">
                                            <small class=\"text-muted mr-2\">Pos.</small>
                                            <input type=\"number\" id=\"nuovaPosizioneVoceMenu{$voceSottoMenu["id"]}\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$voceSottoMenu["posizione"]}\">
                                            <div class=\"input-group-append\">
                                                <button class=\"btn btn-primary\" type=\"button\" onclick=\"spostaVoceMenuInput({$voceSottoMenu["id"]},0)\">Salva</button>
                                            </div>
                                        </div>
                                    </form>
                                    <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                        <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta su\" onclick=\"spostaVoceMenu(1,0)\"><i class=\"fas fa-arrow-up\" ></i></button>
                                        <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta giu\" onclick=\"spostaVoceMenu(1,2)\"><i class=\"fas fa-arrow-down\"></i></button>
                                        <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Configura elemento\" onclick=\"modificaVoceMenu({$voceSottoMenu["id"]},{$voceSottoMenu["idContenuto"]},'{$voceSottoMenu["nome"]}','{$voceSottoMenu["icona"]}','{$voceSottoMenu["link"]}','{$voceSottoMenu["tipo"]}')\"><i class=\"fas fa-cog\"></i></button>
                                        <button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaVoceMenu({$voceSottoMenu["id"]},'{$voceSottoMenu["nome"]}','{$voceSottoMenu["tipo"]}')\" ><i class=\"far fa-trash-alt\"></i></button>
                                    </div>
                                </div>
                            </div>";
                    }
                echo"</div>"
                . "</div>";
        echo"</div>";
    }
